import React from 'react';
import { DetailCustomizationType, DetailCustomizations, Task } from '@flowable/work';

// uncomment the next line to apply a custom theme
//import './theme.scss';

const taskDetailCustomizations = (element: Task): Promise<DetailCustomizations> => {
  //the element contains the task details
  const taskIsComplete = element && !!element.endTime;
  return Promise.resolve({
    externalTabs: {
      prescription: {
        label: 'My custom tab',
        icon: 'video',
        order: 1,
        hidden: taskIsComplete,
        component: () => (
          <div className="flw-youtubeTab">
            <iframe
              width="560"
              height="315"
              src="https://www.youtube.com/embed/29lSAFNkDFc"
              frameBorder="0"
              allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"
              allowFullScreen></iframe>
          </div>
        ),
      },
    },
    typeBadge: {
      label: 'Custom stuff',
      iconName: 'video',
      className: 'flo-typeBadge--custom',
      color: '#FFF',
      background: '#AB47BC',
    },
    tabOverrides: {
      taskForm: {
        hidden: true,
      },
      chat: {
        hidden: true,
      },
      comments: {
        hidden: true,
      },
      people: {
        hidden: true,
      },
      subTasks: {
        hidden: true,
      },
      documents: {
        hidden: true,
      },
      info: {
        hidden: true,
      },
    },
  });
};

const detailCustomizations = (element: any, type: DetailCustomizationType): Promise<DetailCustomizations> => {
  if (type === 'task' && element.category === 'myCustomTask') {
    return taskDetailCustomizations(element);
  }

  return Promise.resolve({ externalTabs: {}, tabOverrides: {} });
};

export default { detailCustomizations };
