# Flowable Infrastructure as Code - Modules - Azure

This repository contains the [Terraform](https://www.terraform.io/) modules that, along with the [Terragrunt](https://github.com/gruntwork-io/terragrunt) configuration files in Flowable Infrastructure as Code - Deployments, can be used to deploy a complete infrastructure running Flowable on various cloud platforms.

## How do you use these modules?

To use a module, create a  `terragrunt.hcl` file that specifies the module you want to use as well as values for the
input variables of that module:

```hcl
# Use Terragrunt to download the module code
terraform {
  source = "git@code.flowable.com:flw-lic/flowable-product/flowable-iac/flowable-iac-modules-azure.git//path/to/module?ref=v0.0.1"
}

# Fill in the variables for that module
inputs = {
  foo = "bar"
  baz = 3
}
```

(*Note: the double slash (`//`) in the `source` URL is intentional and required. It's part of Terraform's Git syntax 
for [module sources](https://www.terraform.io/docs/modules/sources.html).*)

You then run [Terragrunt](https://github.com/gruntwork-io/terragrunt), and it will download the source code specified 
in the `source` URL into a temporary folder, copy your `terragrunt.hcl` file into that folder, and run your Terraform 
command in that folder: 

```
> terragrunt apply
[terragrunt] Reading Terragrunt config file at terragrunt.hcl
[terragrunt] Downloading Terraform configurations from git::git@github.com:gruntwork-io/terragrunt-infrastructure-modules-example.git//path/to/module?ref=v0.0.1
[terragrunt] Copying files from . into .terragrunt-cache
[terragrunt] Running command: terraform apply
[...]
```

Check out the [flowable-iac-deployments 
repo](https://code.flowable.com/flw-lic/flowable-product/flowable-iac/flowable-iac-deployments-azure) for examples.
